function ntkresult = NTKbestresult_D(x,y,id)
kfold = max(id);
[~,T] = size(x);
L_iter = 1:10;
sigmab_iter = [0,0.01,0.1,0.2,0.5,0.8,1,2,5];
sigmaw_iter = [0.5,1,sqrt(2),2,2.5,3];
paramntk = struct();
paramntk.nonlinearity = 1;
mse_test = 10^10;
mse_train = 10^10;
n1 = length(L_iter);
n2 = length(sigmab_iter);
n3 = length(sigmaw_iter);
paramntk_best = struct();
for i = 1:length(L_iter)
    for j = 1:length(sigmab_iter)
        for k = 1:length(sigmaw_iter)
            paramntk.sigmaw = sigmaw_iter(k);
            paramntk.sigmab = sigmab_iter(j);
            paramntk.L = L_iter(i);
            
            kernel_train = cell(kfold,1);
            kernel_test = cell(kfold,1);
            y_train = cell(kfold,1);
            y_test = cell(kfold,1);
            for q = 1:kfold
                id_train = find(id ~= q);
                id_test = find(id == q);
                kernel_train{q} = gramNTK(x(id_train,:),x(id_train,:),paramntk);
                kernel_test{q} = gramNTK(x(id_test,:),x(id_train,:),paramntk);
                y_train{q} = y(id_train);
                y_test{q} = y(id_test);
            end
            [mse_current_test,mse_current_train,lambda_current] = give_me_best_mse(kernel_train,kernel_test,y_train,y_test);
            if mse_current_test < mse_test
               mse_test = mse_current_test;
               mse_train = mse_current_train;
               lambda = lambda_current;
               paramntk_best = paramntk;
            end 
         %percent_complete = 100*((i-1)*n2*n3 + (j-1)*n3 + k)/(n1*n2*n3);
         %fprintf('NTK: %.2f percent complete with best mse: %.5f \n',percent_complete,mse_test);
        end
    end
end
ntkresult = struct();
ntkresult.param = paramntk_best;
ntkresult.lambda = lambda;
ntkresult.mse_test_kfold = mse_test;
ntkresult.mse_train_kfold = mse_train;

end

